/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.compression.lzma.LZMADecoder;
import org.glassfish.grizzly.compression.lzma.LZMAEncoder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.ParsingResult;

public class LZMAContentEncoding
implements ContentEncoding {
    private static final String[] ALIASES = new String[]{"lzma"};
    public static final String NAME = "lzma";
    private final LZMADecoder decoder = new LZMADecoder();
    private final LZMAEncoder encoder = new LZMAEncoder();
    private final EncodingFilter encodingFilter;

    public LZMAContentEncoding() {
        this(null);
    }

    public LZMAContentEncoding(EncodingFilter encodingFilter) {
        this.encodingFilter = encodingFilter != null ? encodingFilter : new EncodingFilter(){

            @Override
            public boolean applyEncoding(HttpHeader httpPacket) {
                return false;
            }

            @Override
            public boolean applyDecoding(HttpHeader httpPacket) {
                return true;
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getAliases() {
        return (String[])ALIASES.clone();
    }

    public static String[] getLzmaAliases() {
        return (String[])ALIASES.clone();
    }

    @Override
    public boolean wantDecode(HttpHeader header) {
        return this.encodingFilter.applyDecoding(header);
    }

    @Override
    public boolean wantEncode(HttpHeader header) {
        return this.encodingFilter.applyEncoding(header);
    }

    @Override
    public ParsingResult decode(Connection connection, HttpContent httpContent) {
        Buffer input2;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        TransformationResult result2 = this.decoder.transform(httpHeader, input2 = httpContent.getContent());
        Buffer remainder = result2.getExternalRemainder();
        if (remainder == null || !remainder.hasRemaining()) {
            input2.tryDispose();
            remainder = null;
        } else {
            input2.shrink();
        }
        try {
            switch (result2.getStatus()) {
                case COMPLETE: {
                    httpContent.setContent((Buffer)result2.getMessage());
                    this.decoder.finish(httpHeader);
                    ParsingResult parsingResult = ParsingResult.create(httpContent, remainder);
                    return parsingResult;
                }
                case INCOMPLETE: {
                    ParsingResult parsingResult = ParsingResult.create(null, remainder);
                    return parsingResult;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA decode error. Code: " + result2.getErrorCode() + " Description: " + result2.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result2.getStatus()));
        }
        finally {
            result2.recycle();
        }
    }

    @Override
    public HttpContent encode(Connection connection, HttpContent httpContent) {
        HttpHeader httpHeader = httpContent.getHttpHeader();
        Buffer input2 = httpContent.getContent();
        if (httpContent.isLast() && !input2.hasRemaining()) {
            return httpContent;
        }
        TransformationResult result2 = this.encoder.transform(httpContent.getHttpHeader(), input2);
        input2.tryDispose();
        try {
            switch (result2.getStatus()) {
                case COMPLETE: {
                    this.encoder.finish(httpHeader);
                }
                case INCOMPLETE: {
                    Buffer encodedBuffer = (Buffer)result2.getMessage();
                    if (encodedBuffer != null) {
                        httpContent.setContent(encodedBuffer);
                        HttpContent httpContent2 = httpContent;
                        return httpContent2;
                    }
                    HttpContent httpContent3 = null;
                    return httpContent3;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA encode error. Code: " + result2.getErrorCode() + " Description: " + result2.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result2.getStatus()));
        }
        finally {
            result2.recycle();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LZMAContentEncoding that = (LZMAContentEncoding)o;
        if (this.decoder != null ? !this.decoder.equals(that.decoder) : that.decoder != null) {
            return false;
        }
        if (this.encoder != null ? !this.encoder.equals(that.encoder) : that.encoder != null) {
            return false;
        }
        return !(this.encodingFilter != null ? !this.encodingFilter.equals(that.encodingFilter) : that.encodingFilter != null);
    }

    public int hashCode() {
        int result2 = this.decoder != null ? this.decoder.hashCode() : 0;
        result2 = 31 * result2 + (this.encoder != null ? this.encoder.hashCode() : 0);
        result2 = 31 * result2 + (this.encodingFilter != null ? this.encodingFilter.hashCode() : 0);
        return result2;
    }
}

